﻿using System;
using System.IO;
using System.Xml.Serialization;

namespace HF_Demo
{
    [Serializable]
    public class Config
    {
        public string TypeOfIso = "ALL";

        #region Serialization

        internal const string FileName = "config.xml";

        public void Save()
        {
            // Open the file
            StreamWriter file = new StreamWriter(IOHelpers.ApplicationPath + FileName, false);

            // Create the serializer
            XmlSerializer serializer = new XmlSerializer(typeof(Config));

            // Write XML information
            serializer.Serialize(file, this);

            // Close the file
            file.Close();
        }

        public static Config Load()
        {
            Config instance = null;

            // Open the file
            StreamReader file = new StreamReader(IOHelpers.ApplicationPath + FileName);

            if (file != null)
            {
                // Read object
                XmlSerializer serializer = new XmlSerializer(typeof(Config));
                instance = (Config)serializer.Deserialize(file);

                // Close the file
                file.Close();
            }

            // return object read (or nothing if error)
            return instance;
        }
        #endregion
    }
}
